-- new script file

function OnAfterSceneLoaded(self)
  self:AddTriggerTarget("questEco")
  self:AddTriggerTarget("questFort")
end

function OnThink(self)
  if not self.initialized then
    self.initialized = true
    self.qDoneFort = false
    self.p0 = Citadels.GetPlayer(0)
    
    if not self.loaded then
      self.qDoneEco = 0
    end
  end
  
  if self.qDoneEco == 8 then
    self.p0:WinQuest('D10_ECONOMY_RAID')
    self.p0:AddResource(4,540)
    self.p0:AddResource(5,680)
    self.p0:AddResource(6,420)
    self.p0:AddResource(7,180)
    self.p0:AddResource(8,1200)
    self.qDoneEco = 0
  end
  
  if self.qDoneFort then
    self.p0:FailQuest('D10_SECOND_FORT')
    self.qDoneFort = false
  end  
end

function OnTrigger(self, source, target)
	if target == "questEco" then
    self.qDoneEco = self.qDoneEco + 1
	elseif target == "questFort" then
    self.qDoneFort = true
  end
end

function OnSerialize(self, ar)
  if (ar:IsLoading()) and Citadels.GetLoadGameRunning() then
    --CreateTriggerSources(self)
    self.loaded = true
    self.ecoCounter = ar:Read()
  elseif (ar:IsSaving()) then
    ar:Write(self.ecoCounter)
  end
end

function CreateTriggerTargets(self)
  self:AddTriggerTarget("questEco")
  self:AddTriggerTarget("questFort")
end
